/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __DRMCHKERR_H
#define __DRMCHKERR_H

/* The dev version only trace in DBG mode. We replace check macroes here to always log results for test code. */
#ifdef __DRMERR_H__
	/* Already included the dev version in drmerr.h. So undef them now. */
	#undef ChkDR
	#undef ChkMem
	#undef ChkArg
	#undef ChkDRMString
	#undef ChkWR
	#undef ChkBOOL
	#undef ChkFAIL
	#undef ChkDRContinue
#else
	/* We don't want to include drmerr.h again. */
	#define __DRMERR_H__
#endif

#define ChkDR(expr) {               \
            dr = (expr);            \
            if ( DRM_FAILED(dr) )   \
            {                       \
				Log("ChkDR", "dr=%#X at %s line %d:%s", dr, __FILE__, __LINE__, #expr); \
                goto ErrorExit;     \
            }                       \
        }

#define ChkMem(expr) {               \
            if ( NULL == (expr) )    \
            {                        \
				Log("ChkMem", "Allocation failure at %s line %d:%s", __FILE__, __LINE__, #expr); \
                dr = DRM_E_OUTOFMEMORY; \
                goto ErrorExit;     \
            }                       \
        }

#define ChkArg(expr) {               \
            if ( !(expr) )       \
            {                       \
				Log("ChkArg", "Invalid argument at %s line %d:%s", __FILE__, __LINE__, #expr); \
                dr = DRM_E_INVALIDARG; \
                goto ErrorExit;     \
            }                       \
        }

#define ChkDRMString(s) {    \
            if ( !(s) || (s)->pwszString==NULL || (s)->cchString==0 )   \
            {                       \
				Log("ChkDRMString", "Invalid DRMString at %s line %d:%s", __FILE__, __LINE__, #s); \
                dr = DRM_E_INVALIDARG; \
                goto ErrorExit;     \
            }                       \
        }

#define ChkWR(expr) {               \
            if (!(expr))            \
            {\
                dr = GetLastError();\
                dr = HRESULT_FROM_WIN32(dr);\
				Log("ChkWR", "WIN32 error %#X at %s line %d:%s", dr, __FILE__, __LINE__, #expr); \
                goto ErrorExit;     \
            }\
        }

#define ChkBOOL(fExpr,err){  \
            if (!(fExpr))            \
            {\
                dr = (err);\
				Log("ChkBOOL", "Error %#X at %s line %d:%s", dr, __FILE__, __LINE__, #fExpr); \
                goto ErrorExit;     \
            }\
        }

#define ChkFAIL(expr) ChkBOOL(expr,DRM_E_FAIL)

#define ChkDRContinue(exp) \
{                          \
    dr=(exp);              \
    if (DRM_FAILED (dr))   \
    {                      \
       Log("ChkDRContinue", "dr=%#X at %s line %d:%s", dr, __FILE__, __LINE__, #exp); \
       continue;          \
    }                      \
}    


#endif /* __DRMERR_H__ */
